# Install Assignment Effort Tables 
# Copyright 2004, 2005, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041222 - first draft of program based on Install Measurement Tracking
# 050606 - Brian - remove "(Hours)" from effort label
# 051114 - Alex - added the same columns to Resource reports
# 060204 - Brian - copied resource name columns here from Install Task Parenting; added assignment Role
# 060204 - Brian - Resource/Assignment's also should be Resource not Task
# 060209 - Alex - removed duplicate scale/effort columns; changed label of Resource/Assignment "EffortHours" column to match Task/Assignment's
# 060717 - Brian - added "ActualEndDate'
# 060720 - Brian - more updates to prepare for inclusion in 0.7 (Project/Name, SuggestedColumns) 

# These design notes are intended to explore the problem. They include more than will be 
#   implemented in the initial version.


#	TaskWeek
#	- ID
#	- TaskID
#	- Period
#	- CalculatedEffort (Plan Hours) (sum of Resource/Task/Week hours)
#	- PercentComplete (not recommended, but okay if EV based on partial completions)

#	TaskDay
#	- ID
#	- TaskID
#	- Period
#	- CalculatedEffort (Plan Hours) (sum of Resource/Task/Day hours)
#	- PercentComplete (not recommended, but okay if EV based on partial completions)

#	ProjectResourceWeek
# 	- ID
#	- ProjectResourceID
#	- Period (Beginning of Week Date - Monday)
#	- ActualEffortHours
#	- ActualCost (not required)
#	- Currency (defaults to ??) (use only if multiple currencies)

#	ProjectResourceDay
# 	- ID
#	- ProjectResourceID
#	- Period (Day)
#	- ActualEffortHours
#	- ActualCost (not required)
#	- Currency (defaults to ??) (use only if multiple currencies)


#	ProjectWeek  (cantains the measurement data for each week)
#	- ID
#	- ProjectID
#	- Period
#	- (Values)  (default: "data is not yet available")


# This script must be run against each file to include the new report options.

# If you want to make sure the report types and column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxDocument", "xxOwner", "xxURL", etc.

def DoAdd():
#    global AddReportType, AddTable, AddRow

    # Specified all required Report Types and Column Types
    # It will either add them or update them if they already exist.

    rt = { 'Name': 'Project', 'TableA': 'Project', 'TableB': None, 'Also': None, 'AllOrEach': 'all',
           'SuggestedColumns': ',Name;,StartDate;,TargetEndDate;,Week/EffortHours,,13' }
    ct = [
    { 'Name': 'ActualEndDate',       'Label': 'Actual\nEnd Date',   'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
#    { 'Name': 'Day/EffortHours',      'Label': 'Day/Effort',        'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
    { 'Name': 'Week/EffortHours',     'Label': 'Week/Effort',       'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
    { 'Name': 'Month/EffortHours',     'Label': 'Month/Effort',       'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Task', 'TableA': 'Task', 'TableB': None, 'Also': None, 'AllOrEach': 'both',
           'SuggestedColumns': ',Name;,StartDate;,DurationHours;,EffortHours;,CalculatedStartDate;,ResourceNames;,Day/Gantt,,21' }
    ct = [
    { 'Name': 'Project/Name',        'Label': "Project\nName",      'DataType': 'y', 'AccessType': 'i', 'T': 'A', 'Edit': False,  'Width': 140 },
    { 'Name': 'EffortHours',         'Label': 'Effort',             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'ResourceNames',       'Label': 'Resource\nNames', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/Name', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'ResourcesShortNames', 'Label': 'Resource\nShort Names', 'Path': 'ID/Assignment/TaskID/ResourceID/Resource/ShortName', 'DataType': 't', 'AccessType': 'list', 'T': 'A', 'Edit': False,  'Width': 80  },
    { 'Name': 'ActualEndDate',       'Label': 'Actual\nEnd Date',   'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'Day/EffortHours',      'Label': 'Day/Effort',        'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
    { 'Name': 'Week/EffortHours',     'Label': 'Week/Effort',       'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
    { 'Name': 'Month/EffortHours',     'Label': 'Month/Effort',       'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Task/Assignment', 'TableA': 'Task', 'TableB': 'Assignment', 'Also': 'Task', 'AllOrEach': 'each',
           'SuggestedColumns': 'Task,Name;Task,DurationHours;Task,EffortHours;,Resource/Name;,Role;,EffortHours;Task,Day/EffortHours,,21' }
    ct = [
    { 'Name': 'Role',                'Label': 'Role',               'DataType': 't', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
    { 'Name': 'EffortHours',         'Label': 'Assignment\nEffort', 'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Resource', 'TableA': 'Resource', 'TableB': None, 'Also': None,
           'SuggestedColumns': ',Name;,Day/EffortHours,,21' }
    ct = [
    { 'Name': 'Day/EffortHours',      'Label': 'Day/Effort',                'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40 },
    { 'Name': 'Week/EffortHours',     'Label': 'Week/Effort',                'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40 },
    { 'Name': 'Month/EffortHours',     'Label': 'Month/Effort',                'DataType': 'i', 'AccessType': 's', 'T': 'X', 'Edit': True,  'Width': 40 },
        ]
    Data.AddReportType(rt, ct)

    rt = { 'Name': 'Resource/Assignment', 'TableA': 'Resource', 'TableB': 'Assignment', 'Also': 'Resource', 'AllOrEach': 'all',
           'SuggestedColumns': 'Resource,Name;,Task/Name;,Role;,EffortHours;Resource,Day/EffortHours,,21' }  
    ct = [
    { 'Name': 'Task/ProjectID',  'Label': 'Project\nID',    'DataType': 'i',  'AccessType': 'i', 'T': 'B', 'Edit': False, 'Width': 60 },
    { 'Name': 'EffortHours',     'Label': 'Assignment\nEffort',         'DataType': 'i', 'AccessType': 'd', 'T': 'B', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)

#    rt = { 'Name': 'ProjectResource', 'Label': 'Project Resource', 'TableA': 'ProjectResource', 'TableB': None, 'Also': None, 'AllOrEach': 'both' }
#    ct = [
#        { 'Name': 'ID',             'Label': None, 'DataType': 'i',  'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 40  },
#        { 'Name': 'ProjectID',      'Label': 'Project\nID', 'DataType': 'i',  'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 80 },
#        { 'Name': 'Project/Name',   'Label': None, 'DataType': 't',  'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 140 },
#        { 'Name': 'ResourceID',     'Label': 'Resource\nID', 'DataType': 'i',  'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80 },
#        { 'Name': 'Resource/Name',  'Label': None, 'DataType': 't',  'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 140 },
#        { 'Name': 'HourlyRate',     'Label': 'Hourly Rate', 'DataType': 'f',  'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80 },
#        { 'Name': 'Week/ActualEffortHours',    'Label': 'Week/ActualEffort', 'DataType': 'i',  'AccessType': 's', 'T': 'A', 'Edit': True,  'Width': 80 },
#        { 'Name': 'Day/ActualEffortHours',     'Label': 'Week/ActualEffort', 'DataType': 'i',  'AccessType': 's', 'T': 'A', 'Edit': True,  'Width': 80 },
#        ]
#    Data.AddReportType(rt, ct)

    # add required data tables
    # Data.AddTable('ProjectDay')
    Data.AddTable('ProjectWeek')
    Data.AddTable('ProjectMonth')
    Data.AddTable('TaskDay')
    Data.AddTable('TaskWeek')
    Data.AddTable('TaskMonth')
    Data.AddTable('ResourceDay')
    Data.AddTable('ResourceWeek')
    Data.AddTable('ResourceMonth')
    Data.AddTable('AssignmentDay')
    Data.AddTable('AssignmentWeek')
    Data.AddTable('AssignmentMonth')

    Data.SetUndo("Install Assignment Effort Tables")

# do only if GanttPV version 0.2 or greater
DoAdd()
